package de.davidartmann.rosa.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

import de.davidartmann.rosa.model.Person;

/**
 * Database Helper class.
 * Created by david on 01.03.16.
 */
public class RosaDbHelper extends SQLiteOpenHelper {

    private static final int DB_VERSION = 1;
    private static final String DB_NAME = "rosa.db";
    public static final String TABLE_PERSON = "person";

    public RosaDbHelper(Context context) {
        super(context, DB_NAME, null, DB_VERSION);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL(Person.createPersonTable());
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < newVersion) {
            //TODO: make update stmt
            db.execSQL("DROP TABLE IF EXISTS " + TABLE_PERSON);
        }
        onCreate(db);
    }
}
